
<?php $__env->startSection('titulo', 'lista de Certificado'); ?>

<?php $__env->startSection('content'); ?>

    



    <h4 class="text-center text-secondary">LISTA DE MODELO DE CERTIFICADOS</h4>

    <div class="form-group row col-12 px-4">
        <div class="col-12 col-sm-9">
            <input type="text" id="nombre" class="form-control p-3"
                placeholder="Ingrese el Nombre o Descripción del curso">
        </div>
        <button id="buscar" class="btn btn-success col-12 col-sm-3 mt-2 mt-sm-0" type="submit"><i class="fas fa-search"></i> Buscar</button>
    </div>
    <div class="card-block table-responsive">
        <table id="" class="display table table-striped" cellspacing="0" width="100%">
            <thead class="table-primary">
                <tr>
                    <th class="sorting_desc">ID</th>
                    <th>CURSO</th>
                    <th>DESCRIPCION</th>
                    
                    <th></th>
                </tr>
            </thead>

            <tbody id="tbody">

            </tbody>
        </table>
    </div>


    <div>
        <?php if(session('CORRECTO')): ?>
            <div class="alert alert-success"><i class="fas fa-check"></i> <?php echo e(session('CORRECTO')); ?></div>
        <?php endif; ?>

        <?php if(session('INCORRECTO')): ?>
            <div class="alert alert-error"><i class="fas fa-times"></i> <?php echo e(session('INCORRECTO')); ?></div>
        <?php endif; ?>

        <?php if(session('DUPLICADO')): ?>
            <div class="alert alert-error"><i class="fas fa-exclamation-triangle"></i> <?php echo e(session('DUPLICADO')); ?></div>
        <?php endif; ?>



        <?php $__errorArgs = ['modelo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="alert alert-error"><i class="fas fa-times"></i> <?php echo e($message); ?></div>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        <?php $__errorArgs = ['curso'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="alert alert-error"><i class="fas fa-times"></i> <?php echo e($message); ?></div>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        <?php $__errorArgs = ['txtid'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="alert alert-error"><i class="fas fa-times"></i> <?php echo e($message); ?></div>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>


    <section class="card">
        <div class="card-block">
            <table id="example2" class="display table table-striped" cellspacing="0" width="100%">
                <thead class="table-primary">
                    <tr>
                        <th class="sorting_desc">ID</th>
                        <th>CURSO</th>
                        <th>MODELO</th>
                        <th></th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $datos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($item->id_certificado); ?></td>
                            <td style="width: 300px"><?php echo e($item->nombre); ?></td>
                            <td>
                                <?php if($item->modelo != ''): ?>
                                    <a class="text-primary" data-toggle="modal"
                                        data-target="#ver<?php echo e($item->id_certificado); ?>"><i class="fas fa-eye"></i>Ver
                                        modelo</a>
                                <?php endif; ?>
                            </td>

                            <td>

                                <?php if($item->id_certificado != ''): ?>
                                    <a style="top: 0" href="" class="btn btn-sm btn-warning m-1" data-toggle="modal"
                                        data-target="#nuevo<?php echo e($key); ?>"><i class="fas fa-edit"></i></a>

                                    <a style="top: 0" href="<?php echo e(route('certificado.show', $item->id_certificado)); ?>"
                                        class="btn btn-sm btn-primary m-1"><i class="fas fa-wrench"></i></a>
                                <?php else: ?>
                                    <a style="top: 0" href="" class="btn btn-sm btn-success m-1" data-toggle="modal"
                                        data-target="#agregar<?php echo e($key); ?>"><i class="fas fa-plus"></i></a>
                                <?php endif; ?>


                            </td>


                            <?php if($item->id_certificado != ''): ?>
                                
                                <div class="modal fade" id="nuevo<?php echo e($key); ?>" data-backdrop="static"
                                    data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel"
                                    aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div style="background: rgb(181, 211, 255)"
                                                class="px-4 py-3 w-100 d-flex justify-content-between">
                                                <h5 class="modal-title" id="staticBackdropLabel">Modelo de certificado</h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="p-3">
                                                <div>
                                                    <div class="text-center">
                                                        <?php if($item->modelo != ''): ?>
                                                            <img style="width: 180px"
                                                                src="<?php echo e(asset("modelo_certificados/$item->modelo")); ?>"
                                                                alt="">
                                                        <?php endif; ?>
                                                    </div>

                                                    <form action="<?php echo e(route('certificado.add', $item->id_certificado)); ?>"
                                                        method="POST" enctype="multipart/form-data">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('PUT'); ?>
                                                        <div class="row">

                                                            <input type="hidden" value="<?php echo e($item->modelo); ?>"
                                                                name="txtid">
                                                            <input type="hidden" name="curso"
                                                                value="<?php echo e($item->id_curso); ?>">
                                                            <div class="fl-flex-label mb-4 col-12 col-lg-12">
                                                                <input required type="file" name="modelo"
                                                                    class="input input__text" value="<?php echo e(old('modelo')); ?>">
                                                            </div>

                                                        </div>

                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary"
                                                                data-dismiss="modal"><i class="fas fa-times"></i> Cerrar</button>
                                                            <button type="submit"
                                                                class="btn btn-primary"><i class="fas fa-save"></i> Modificar</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="modal fade" id="ver<?php echo e($item->id_certificado); ?>"
                                    aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div style="background: rgb(181, 211, 255)"
                                                class="px-4 py-3 w-100 d-flex justify-content-between">
                                                <h5 class="modal-title" id="staticBackdropLabel">Modelo de certificado
                                                </h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="p-3">
                                                <div>
                                                    <div class="text-center">
                                                        <?php if($item->modelo != ''): ?>
                                                            <img class="img-fluid"
                                                                src="<?php echo e(asset("modelo_certificados/$item->modelo")); ?>"
                                                                alt="">
                                                        <?php endif; ?>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary"
                                                            data-dismiss="modal"><i class="fas fa-times"></i> Cerrar</button>
                                                        <form action="<?php echo e(route('certificado.eliminarModelo',$item->id_certificado)); ?>" method="get"
                                                            class="d-inline formulario-eliminar">
                                                        </form>
                                                        <a href="#" class="btn btn-danger eliminar"
                                                            data-id="<?php echo e($item->id_certificado); ?>">
                                                            <i class="fas fa-trash-alt"></i> Eliminar este modelo
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="modal fade" id="agregar<?php echo e($key); ?>" data-backdrop="static"
                                    data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel"
                                    aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div style="background: rgb(181, 211, 255)"
                                                class="px-4 py-3 w-100 d-flex justify-content-between">
                                                <h5 class="modal-title" id="staticBackdropLabel">Agregar Modelo de
                                                    certificado</h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="p-3">
                                                <div>
                                                    <form action="<?php echo e(route('certificado.store')); ?>" method="POST"
                                                        enctype="multipart/form-data">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="row">

                                                            <div class="fl-flex-label mb-4 col-12 col-lg-12">
                                                                <input required type="file" name="modelo"
                                                                    class="input input__text"
                                                                    value="<?php echo e(old('modelo')); ?>">

                                                            </div>

                                                            <div class="fl-flex-label mb-4 col-12 col-lg-12">
                                                                <select required class="input input__select" name="curso">
                                                                    <option value="<?php echo e($item->id_curso); ?>">
                                                                        <?php echo e($item->nombre); ?></option>
                                                                </select>
                                                            </div>


                                                        </div>

                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary"
                                                                data-dismiss="modal"><i class="fas fa-times"></i> Cerrar</button>
                                                            <button type="submit"
                                                                class="btn btn-primary"><i class="fas fa-save"></i> Registrar</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>




                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="text-right">
                <?php echo e($datos->links('pagination::bootstrap-4')); ?>

                Mostrando <?php echo e($datos->firstItem()); ?> - <?php echo e($datos->lastItem()); ?> de <?php echo e($datos->total()); ?>

                resultados
            </div>
        </div>
    </section>

    <script>
        let buscar = document.getElementById("buscar");
        let valor = document.getElementById("nombre");
        valor.addEventListener("blur", buscarEstudiante)
        valor.addEventListener("keyup", buscarEstudiante)
        buscar.addEventListener("click", buscarEstudiante)


        function buscarEstudiante() {
            let valor = document.getElementById("nombre").value;
            // if (valor == "") {
            //     alert("Ingrese datos para buscar")
            // }
            var ruta = "<?php echo e(url('buscar/certificado')); ?>/" + valor + "";
            $.ajax({
                url: ruta,
                type: "get",
                success: function(data) {
                    let tr = document.createElement("tr");
                    let tbody = document.querySelector("tbody");
                    let fragmento = document.createDocumentFragment();
                    let td = "";
                    data.dato.forEach(function(item, index) {
                        td +=
                            `<tr>
                                <td>${item.id_curso}</td>
                                <td>${item.nombre}</td>
                                <td>${item.descripcion}</td>
                                <td>
                                    <a style="top: 0" href="certificado/ver/certificado/${item.id_curso}" class="btn btn-sm btn-primary m-1"><i class="fas fa-eye"></i> Ver</a>
                                </td>


                            </tr>`;
                        tbody.innerHTML = td
                    })

                },
                error: function(data) {
                    let tbody = document.getElementById("tbody");
                    tbody.innerHTML = ""
                }
            })
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\PROYECTOS-LARAVEL\sis_certificados\resources\views/certificado/listaCertificado.blade.php ENDPATH**/ ?>